using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace MojaPierwszaGraXNA
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        Effect efekt;
        Matrix World, View, Projection;
        
        Kwadryka sfera;

        public Game1()
        {
            Window.Title = "Modul 2. Owietlenie: Laboratorium rozszerzone";
            //Window.AllowUserResizing = true;

            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {            
            sfera = Kwadryka.StworzSfere(graphics.GraphicsDevice, 0.75f, 100, 100, Color.White);            

            Projection = Matrix.CreateOrthographic(2.0f * graphics.GraphicsDevice.Viewport.AspectRatio, 2.0f, 0.0f, 100.0f);
            View = Matrix.CreateLookAt(new Vector3(0, 0, 2), new Vector3(0, 0, 0), new Vector3(0, 1, 0));
            World = Matrix.CreateRotationX(-MathHelper.PiOver2);

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            efekt = Content.Load<Effect>("phong");
            efekt.Parameters["WorldViewProjection"].SetValue(World * View * Projection);
            efekt.Parameters["World"].SetValue(World);
            efekt.Parameters["Kolor"].SetValue(Color.White.ToVector4());
            efekt.Parameters["MapujKolorWerteksu"].SetValue(false);
            efekt.Parameters["OswietleniePerPixel"].SetValue(true);

            efekt.Parameters["Ca"].SetValue(new Vector4(0.5f, 0.5f, 0.5f, 1));
            efekt.Parameters["Cd"].SetValue(new Vector4(0.75f, 0.75f, 0.75f, 1));
            efekt.Parameters["Cd"].SetValue(new Vector4(1, 1, 1, 1));

            efekt.Parameters["Tekstura"].SetValue(this.Content.Load<Texture2D>("Ziemia"));
            efekt.Parameters["Tekstura2"].SetValue(this.Content.Load<Texture2D>("Ziemia_negatyw"));
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            //klawiatura
            if (Keyboard.GetState().IsKeyDown(Keys.Escape)) this.Exit();
            if (Keyboard.GetState().IsKeyDown(Keys.Space)) graphics.ToggleFullScreen();            

            if (Keyboard.GetState().IsKeyDown(Keys.Up)) World *= Matrix.CreateRotationX(-0.01f);
            if (Keyboard.GetState().IsKeyDown(Keys.Down)) World *= Matrix.CreateRotationX(0.01f);

            World *= Matrix.CreateRotationY(gameTime.ElapsedGameTime.Milliseconds / 3000.0f);
            efekt.Parameters["WorldViewProjection"].SetValue(World * View * Projection);
            efekt.Parameters["World"].SetValue(World);

            
            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            //graphics.GraphicsDevice.Clear(Color.CornflowerBlue);            

            // TODO: Add your drawing code here                    
            GraphicsDevice gd = graphics.GraphicsDevice;
            gd.Clear(Color.Black);
            //gd.RenderState.CullMode = CullMode.CullCounterClockwiseFace;
            gd.RasterizerState = RasterizerState.CullNone;

            sfera.Rysuj(efekt);

            base.Draw(gameTime);
        }
    }
}
